import React from "react";
import {
  Upload,
  Share2,
  Shield,
  Zap,
  Clock,
  Users,
  TrendingUp,
  FileText,
  Download,
  Link2,
} from "lucide-react";
import { Link } from "react-router-dom";

export default function Dashboard() {
  const stats = [
    {
      label: "Files Uploaded",
      value: "1,234",
      icon: Upload,
      color: "from-blue-500 to-cyan-500",
    },
    {
      label: "Total Shares",
      value: "5,678",
      icon: Share2,
      color: "from-purple-500 to-pink-500",
    },
    {
      label: "Active Links",
      value: "892",
      icon: Link2,
      color: "from-green-500 to-emerald-500",
    },
    {
      label: "Total Downloads",
      value: "12.5K",
      icon: Download,
      color: "from-orange-500 to-red-500",
    },
  ];

  const features = [
    {
      icon: Zap,
      title: "Lightning Fast",
      description:
        "Upload and share files in seconds with our optimized infrastructure",
    },
    {
      icon: Shield,
      title: "Secure & Encrypted",
      description:
        "End-to-end encryption ensures your files remain private and safe",
    },
    {
      icon: Clock,
      title: "Time-Limited Links",
      description:
        "Set expiration dates for your shared links for added security",
    },
    {
      icon: Users,
      title: "Easy Sharing",
      description:
        "Share files with anyone using simple, shareable download links",
    },
  ];

  const recentActivity = [
    {
      name: "Project_Proposal.pdf",
      size: "2.4 MB",
      time: "2 mins ago",
      downloads: 5,
    },
    {
      name: "Design_Assets.zip",
      size: "45.8 MB",
      time: "1 hour ago",
      downloads: 12,
    },
    {
      name: "Meeting_Notes.docx",
      size: "1.2 MB",
      time: "3 hours ago",
      downloads: 3,
    },
  ];

  return (
    <div className="min-h-screen bg-gradient-to-br from-indigo-100 via-purple-50 to-pink-100">
      {/* Decorative elements */}
      <div className="absolute top-0 left-0 w-96 h-96 bg-purple-300 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob"></div>
      <div className="absolute top-0 right-0 w-96 h-96 bg-indigo-300 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-2000"></div>
      <div className="absolute bottom-0 left-1/2 w-96 h-96 bg-pink-300 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-4000"></div>

      <div className="relative max-w-7xl mx-auto px-4 py-12">
        {/* Hero Section */}
        <div className="text-center mb-12">
          <div className="inline-flex items-center gap-3 mb-6">
            <div className="w-16 h-16 bg-gradient-to-br from-indigo-600 to-purple-600 rounded-2xl flex items-center justify-center shadow-xl">
              <FileText className="w-8 h-8 text-white" />
            </div>
          </div>
          <h1 className="text-5xl md:text-6xl font-bold mb-4">
            <span className="bg-gradient-to-r from-indigo-600 via-purple-600 to-pink-600 bg-clip-text text-transparent">
              Welcome to FileShare
            </span>
          </h1>
          <p className="text-xl text-gray-700 mb-8 max-w-2xl mx-auto">
            Upload files and share secure download links easily. Fast, secure,
            and simple file sharing for everyone.
          </p>
          <div className="flex flex-wrap gap-4 justify-center">
            <Link to='/upload' className="px-8 py-4 bg-gradient-to-r from-indigo-600 to-purple-600 text-white rounded-xl font-semibold hover:from-indigo-700 hover:to-purple-700 transition-all shadow-lg hover:shadow-xl flex items-center gap-2">
              <Upload className="w-5 h-5" />
              Upload File
            </Link>
            <button className="px-8 py-4 bg-white/80 backdrop-blur-sm text-gray-700 rounded-xl font-semibold hover:bg-white transition-all shadow-lg hover:shadow-xl border border-white/20 flex items-center gap-2">
              <TrendingUp className="w-5 h-5" />
              View Analytics
            </button>
          </div>
        </div>

        {/* Stats Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-12">
          {stats.map((stat, index) => (
            <div
              key={index}
              className="bg-white/80 backdrop-blur-lg rounded-2xl p-6 border border-white/20 shadow-lg hover:shadow-xl transition-all"
            >
              <div className="flex items-center justify-between mb-4">
                <div
                  className={`w-12 h-12 bg-gradient-to-br ${stat.color} rounded-xl flex items-center justify-center`}
                >
                  <stat.icon className="w-6 h-6 text-white" />
                </div>
                <TrendingUp className="w-5 h-5 text-green-500" />
              </div>
              <h3 className="text-3xl font-bold text-gray-800 mb-1">
                {stat.value}
              </h3>
              <p className="text-sm text-gray-600">{stat.label}</p>
            </div>
          ))}
        </div>

        {/* Features Grid */}
        <div className="grid md:grid-cols-2 gap-6 mb-12">
          {features.map((feature, index) => (
            <div
              key={index}
              className="bg-white/80 backdrop-blur-lg rounded-2xl p-8 border border-white/20 shadow-lg hover:shadow-xl transition-all group"
            >
              <div className="w-14 h-14 bg-gradient-to-br from-indigo-100 to-purple-100 rounded-xl flex items-center justify-center mb-4 group-hover:scale-110 transition-transform">
                <feature.icon className="w-7 h-7 text-indigo-600" />
              </div>
              <h3 className="text-xl font-bold text-gray-800 mb-2">
                {feature.title}
              </h3>
              <p className="text-gray-600">{feature.description}</p>
            </div>
          ))}
        </div>

        {/* Recent Activity */}
        <div className="bg-white/80 backdrop-blur-lg rounded-2xl p-8 border border-white/20 shadow-lg">
          <div className="flex items-center justify-between mb-6">
            <h2 className="text-2xl font-bold text-gray-800">
              Recent Activity
            </h2>
            <button className="text-indigo-600 hover:text-indigo-700 font-semibold text-sm">
              View All
            </button>
          </div>
          <div className="space-y-4">
            {recentActivity.map((item, index) => (
              <div
                key={index}
                className="flex items-center justify-between p-4 bg-gradient-to-r from-indigo-50 to-purple-50 rounded-xl hover:from-indigo-100 hover:to-purple-100 transition-all border border-indigo-100"
              >
                <div className="flex items-center gap-4 flex-1 min-w-0">
                  <div className="w-12 h-12 bg-gradient-to-br from-indigo-600 to-purple-600 rounded-lg flex items-center justify-center flex-shrink-0">
                    <FileText className="w-6 h-6 text-white" />
                  </div>
                  <div className="flex-1 min-w-0">
                    <p className="font-semibold text-gray-800 truncate">
                      {item.name}
                    </p>
                    <p className="text-sm text-gray-600">
                      {item.size} • {item.time}
                    </p>
                  </div>
                </div>
                <div className="flex items-center gap-2 ml-4">
                  <div className="flex items-center gap-1 px-3 py-1 bg-white rounded-lg">
                    <Download className="w-4 h-4 text-gray-600" />
                    <span className="text-sm font-semibold text-gray-700">
                      {item.downloads}
                    </span>
                  </div>
                  <button className="p-2 hover:bg-white rounded-lg transition-colors">
                    <Share2 className="w-5 h-5 text-gray-600" />
                  </button>
                </div>
              </div>
            ))}
          </div>
        </div>

        {/* CTA Section */}
        <div className="mt-12 bg-gradient-to-r from-indigo-600 to-purple-600 rounded-3xl p-12 text-center shadow-2xl">
          <h2 className="text-3xl md:text-4xl font-bold text-white mb-4">
            Ready to Share Your Files?
          </h2>
          <p className="text-indigo-100 mb-8 text-lg max-w-2xl mx-auto">
            Start uploading and sharing files securely with our powerful
            platform. No limits, no hassle.
          </p>
          <button className="px-10 py-4 bg-white text-indigo-600 rounded-xl font-bold hover:bg-gray-50 transition-all shadow-lg hover:shadow-xl inline-flex items-center gap-2">
            <Upload className="w-5 h-5" />
            Get Started Now
          </button>
        </div>
      </div>
    </div>
  );
}
